/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

public class MemoryPtr {
    private byte[] memory;
    private int offset;

    public MemoryPtr(byte[] memory, int offset) {
        this.memory = memory;
        this.offset = offset;
    }

    public void get(byte[] raw_bytes) {
        int i = 0;
        while (i < raw_bytes.length) {
            raw_bytes[i] = this.memory[(i + this.offset) % this.memory.length];
            ++i;
        }
    }

    public int getWordOp() {
        return (this.memory[(this.offset + 1) % this.memory.length] & 0xFF) + ((this.memory[(this.offset + 2) % this.memory.length] & 0xFF) << 8);
    }

    public int getWordOp(int disp) {
        return (this.memory[(this.offset + 1 + disp) % this.memory.length] & 0xFF) + ((this.memory[(this.offset + 2 + disp) % this.memory.length] & 0xFF) << 8);
    }

    public int getByteOp() {
        return this.memory[(this.offset + 1) % this.memory.length] & 0xFF;
    }

    public long getByteOp(int disp) {
        return this.memory[(this.offset + 1 + disp) % this.memory.length] & 0xFF;
    }

    public int getRelativeOp() {
        int jumprel = this.getByteOp();
        if (jumprel > 127) {
            jumprel -= 256;
        }
        return this.offset + 2 + jumprel;
    }

    public int getAddress() {
        return this.offset + 1;
    }

    public void setAddress(int address) {
        this.offset = address - 1;
    }
}

